/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: cifXDriver_internal.h $
   Last Modification:
    $Author: sebastiand $
    $Modtime: 28.09.07 15:16 $
    $Revision: 1909 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : yes
 
   Description:
    Internal cifX CE Driver definitions
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
	   1         15.03.2011  SD       Created

 
**************************************************************************************/

/*****************************************************************************/
/*!\file cifXDriver_internal.h
*   Internal cifX CE Driver definitions                                      */
/*****************************************************************************/

#ifndef __CIFXDRIVER_INTERNAL__H
#define __CIFXDRIVER_INTERNAL__H

/*****************************************************************************/
/*! Local Control Register Offsets                                           */
/*****************************************************************************/
#define PLX_PCI_INTCTRLSTS_REG  0x4C

#define PLX_HW_INTERRUPT_DISABLE            0x00
#define PLX_HW_INTERRUPT_ENABLE             0x01
#define PLX_HW_INTERRUPT_STATE              0x04

/*****************************************************************************/
/*! Callback registration data                                               */
/*****************************************************************************/
typedef struct CALLBACK_REGISTRATION_Ttag
{
  HANDLE        hUserEvent;       /*!< Event to signal to user                  */
  /* TODO: Define how large the callback data can get */
  BYTE          abNotifyData[128];  /*!< Notification data stored from toolkit */
  unsigned long ulNotifyDataLen;    /*!< Length of stored notification data    */

} CALLBACK_REGISTRATION_T;

#define CIFX_NOTIFY_MAX  8

// ///////////////////////////////////////////////////// 
//! Internal Driver Device instance
// ///////////////////////////////////////////////////// 
typedef struct CIFXCEDRV_DEVICEINSTANCEtag
{
  DEVICEINSTANCE tDevInstance;  /*!< Toolkit device instance */

  TCHAR*         szDeviceKey;   /*!< Device key "\\drivers\builtin\cifxdev0" */
  TCHAR*         szDevicename;  /*!< Name of the device */

  BOOL              fPLXBridge;
  unsigned long     ulPciConfigSize;
  unsigned long     ulBusNumber;
  unsigned long     ulSlotNumber;
  PCI_COMMON_CONFIG tPciConfig;    /*!< PCI configuration */
  unsigned long     ulPLXRegistersLen;
  unsigned char*    pbPLXRegisters;

  HANDLE         hLogFile;      /*!< Handle to the log file to write traces to */

  HANDLE         hIntChain;
  DDKISRINFO     tIsrInfo;      /*!< ISR info from registry         */
  BOOLEAN        fStopIst;      /*!< TRUE if IST should be stopped  */
  HANDLE         hIst;          /*!< Handle to IST                  */
  HANDLE         hIrqEvent;     /*!< Handle to IRQ Event            */

  CIFXHANDLE     hDriver;       /*!< Handle to the driver returned from xOpenDriver */
  unsigned long  ulOpenCount;   /*!< Number of times the driver was opened          */

  CIFXHANDLE     hSysDevice;          /*!< Handle to system device returned from xSysdeviceOpen */
  unsigned long  ulSysdeviceOpenCnt;  /*!< Number of times the system device was opened         */

  CIFXHANDLE     ahChannels[CIFX_MAX_NUMBER_OF_CHANNELS];         /*!< Handles to channels returned from xChannelOpen */
  unsigned long  aulChannelOpenCnt[CIFX_MAX_NUMBER_OF_CHANNELS];  /*!< Number of times the channel was opened         */

  CALLBACK_REGISTRATION_T  aatNotifyCallbacks[CIFX_MAX_NUMBER_OF_CHANNELS][CIFX_NOTIFY_MAX];

} CIFXCEDRV_DEVICEINSTANCE, *PCIFXCEDRV_DEVICEINSTANCE;

#endif //__CIFXDRIVER_INTERNAL__H
